<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = trim($_POST['name']);
    $color = trim($_POST['color']);

    if (empty($name)) {
        die("Lūdzu ievadiet kalendāra nosaukumu.");
    }

    $stmt = $pdo->prepare("INSERT INTO calendars (user_id, name, color) VALUES (?, ?, ?)");
    $stmt->execute([$_SESSION['user_id'], $name, $color]);

    header("Location: dashboard.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izveidot kalendāru</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
<?php include 'header.php'; ?>

<h1>Izveidot jaunu kalendāru</h1>
<form method="POST">
    <label for="name">Nosaukums:</label>
    <input type="text" name="name" id="name" required>

    <label for="color">Krāsa:</label>
    <input type="color" name="color" id="color" value="#000000" required>

    <button type="submit">Izveidot</button>
</form>

<?php include 'footer.php'; ?>
</body>
</html>